
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Feb 20 16:25:49 2005
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version CRYS_Ext_ATP_DH_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
    
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */ 
/*lint --e{785} */   
    
/***************************
 * File Name:                                                           
 *  CRYS_Ext_ATP_DH_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for DH Acceptance tests                               
 *
 **************************/


/***** Include Files **********/
#include "CRYS_Ext_ATP_DH_Acceptance.h" 

/******** Defines *********/
/******** Enums *********/
/******** Typedefs ********/
/******** Global Data *******/
/***** Private function prototype *****/
/******** Public Functions ******/
/****/
/* PKCS#3 */
/****/
SEP_DH_TestDataStructPKCS3 SEP_DH_Acceptance_PKCS3_TestDataStruct[] = 
{
	{ 
        {"Acceptance test - DH PKCS#3/Prime-2048/Generator-2048/l=12"}, 
        /*TST_Generator - G*/
        {0xc0,0x27,0xaf,0xaf,0x57,0x1a,0x9e,0xd6,0x9a,0x24,0x2f,0xef,0x31,0x30,0x58,0xba,
         0x14,0x77,0xdc,0x60,0x11,0x43,0x10,0x4a,0x80,0xe3,0xd8,0xa6,0xe3,0x00,0x11,0x87,
         0x24,0x8f,0x3c,0xf6,0x48,0x4f,0xfd,0xd7,0x22,0x4c,0x76,0xb0,0xaa,0xb4,0x22,0xe9,
         0xd4,0xb7,0xed,0x9a,0x1a,0xea,0xa2,0x01,0x57,0x52,0xb0,0x9e,0xae,0x3e,0x45,0x3a,
         0x1e,0x56,0x5b,0xda,0x4d,0x35,0x67,0x2a,0xb8,0x9d,0x77,0xb0,0xa8,0x5e,0xc8,0xd4,
         0x06,0x82,0x5f,0x15,0x82,0xe5,0x45,0x8f,0xf6,0x9a,0xab,0x5c,0x96,0x38,0xcc,0x19,
         0x94,0x2d,0xc5,0x25,0x40,0x24,0x4c,0x3f,0xc7,0x8d,0x08,0x5b,0x68,0x21,0xb2,0xb6,
         0x4f,0x1a,0x1f,0x42,0x3b,0xf4,0x9c,0x0b,0x98,0x10,0xd5,0x56,0xac,0x88,0x4b,0x8c,
         0x39,0x79,0xde,0xf7,0xca,0xfc,0x31,0xaf,0x67,0x91,0x0b,0xb7,0xcd,0x67,0x01,0x72,
         0x8a,0x52,0xc1,0xf5,0x98,0x97,0x47,0x36,0x23,0xab,0x8e,0xf5,0x8a,0x30,0xf4,0x62,
         0x07,0x55,0x57,0x7e,0xf9,0xa1,0x76,0x4c,0xa8,0xb0,0xe0,0xc9,0xb1,0xa0,0x86,0x5e,
         0xc9,0x13,0x36,0xe7,0xdd,0x02,0x89,0xf6,0x0b,0x0c,0xf4,0x49,0xf7,0xa6,0xcb,0x03,
         0xb7,0x80,0x54,0xbf,0x5b,0xeb,0x6b,0x92,0xfd,0x62,0xe0,0x2a,0xb0,0x6c,0xeb,0x6d,
         0x34,0x1d,0xe1,0x89,0x92,0xcb,0x21,0xbc,0x53,0x45,0x1b,0x13,0xa8,0xe2,0xb6,0x50,
         0xd4,0xf5,0x3a,0x44,0x52,0x5c,0x10,0x08,0x0a,0x95,0xfc,0x6a,0x2c,0x92,0xc0,0x21,
         0x73,0xc5,0xab,0x6e,0x94,0x3e,0x0f,0x6b,0xd2,0xa4,0x85,0xea,0xd9,0x20,0x98,0xd5},  
        /*TST_GeneratorSize;*/
        256*sizeof(DxUint8_t),
        /*TST_Prime - P*/
        {0xd3,0xa2,0x3a,0xbc,0xcc,0xa2,0xe7,0xc3,0x39,0x2a,0x8b,0x5c,0x8a,0x3c,0x29,0x39,
         0xa1,0xef,0xf4,0xe2,0x06,0x79,0xae,0x2b,0xca,0xde,0xad,0x84,0x91,0xcd,0xe6,0x3a,
         0x07,0x24,0xaa,0x4d,0xa0,0x02,0xea,0xe2,0xb2,0xd6,0xcb,0x3a,0xf3,0x2b,0x8c,0x92,
         0xaa,0xea,0x47,0x9f,0x5b,0xc7,0xf8,0xfe,0xf8,0x09,0x6e,0x1a,0x3a,0xcc,0x22,0x9b,
         0xb5,0xe2,0x6b,0x4e,0xab,0x67,0xc6,0x25,0x24,0xd7,0x17,0x92,0x73,0x37,0xd1,0x2b,
         0x90,0xab,0xa0,0xeb,0xf9,0x2e,0x1d,0xe7,0xc3,0x29,0x5d,0x78,0x46,0x0f,0xf4,0x2b,
         0xb1,0xa5,0x71,0xfb,0x43,0xba,0x19,0xa6,0x59,0xca,0x20,0xc2,0x2f,0x33,0x0e,0xae,
         0xec,0xcd,0x23,0x1a,0x54,0x83,0xe7,0x7a,0x83,0x58,0xc5,0xc2,0x71,0xb3,0x9e,0xad,
         0x64,0x3f,0x4f,0x63,0xb4,0xf4,0xa5,0x6f,0xa4,0x66,0x10,0x62,0x00,0xa7,0x30,0x2f,
         0x7d,0x37,0x2a,0x97,0xc0,0xc6,0x9b,0x13,0x2d,0x11,0x95,0x20,0x2c,0x2c,0x68,0x81,
         0x70,0x30,0xf0,0xa7,0x45,0x12,0x4c,0xbf,0x99,0xa3,0xd3,0x70,0x26,0x00,0x2e,0x4a,
         0xc6,0xdc,0x59,0xe9,0xdf,0x1c,0x1f,0x1a,0xd5,0x02,0xe5,0xda,0xe7,0x5f,0xb4,0x4d,
         0x39,0x82,0xf0,0x81,0xd1,0x6b,0xd8,0xda,0xf5,0xa4,0x33,0x53,0xe9,0x9a,0x75,0x5a,
         0x8e,0x95,0xcb,0x8a,0xcf,0x82,0x5b,0x8d,0x65,0x9b,0x7d,0x72,0x64,0x57,0xfa,0x7a,
         0xdb,0x3e,0x5f,0x5b,0xa5,0x92,0x14,0xea,0xa3,0xbb,0xf6,0xa9,0x70,0x41,0xfa,0x8b,
         0xe9,0x80,0x75,0xe7,0xa6,0x5d,0xdf,0x54,0xee,0x10,0x41,0x6c,0x5b,0xbc,0x64,0xa1},
        /*TST_PrimeSize*/
        256*sizeof(DxUint8_t),
        /*TST_L*/
        12,       
    }  
};
/*****/
/* ANSI942 */
/*****/
SEP_DH_TestDataStructANSI942 SEP_DH_Acceptance_ANSI942_TestDataStruct[] = 
{
	{ 
        {"Acceptance test - DH ANSI9.42/Prime-2048/Generator-2048/Q-160/\n  DH_HASH_SHA1_mode/DH_ASN1_Der_mode"},
        /*TST_Generator - G*/
		{0x6a, 0xdc, 0xe6, 0x26, 0x4f, 0xf7, 0xd9, 0x8e, 0x63, 0xca, 0x9a, 0xce, 0x96, 0x67, 0x7c, 0xe2, 
		0x94, 0x5a, 0x92, 0x67, 0x9d, 0xa6, 0xd3, 0xa0, 0xfd, 0x0e, 0x0e, 0x60, 0x10, 0xc3, 0x8b, 0x5f, 
		0x7a, 0x15, 0x7b, 0xd8, 0x73, 0x99, 0x8f, 0x93, 0xbe, 0x8d, 0x85, 0x8d, 0x13, 0x05, 0x8e, 0x0c,
		0x46, 0x73, 0x96, 0xdd, 0x60, 0xde, 0x7b, 0xd2, 0xb0, 0x1c, 0x4f, 0x36, 0x41, 0x31, 0xf0, 0xaa, 
		0x4b, 0x4e, 0xca, 0xbb, 0x1e, 0x18, 0xc6, 0x97, 0x13, 0xe4, 0x9a, 0xdd, 0x7f, 0x51, 0x59, 0x80,
		0x97, 0xe7, 0x57, 0x67, 0x89, 0xa8, 0x91, 0x2b, 0x9f, 0x18, 0x82, 0x42, 0x4e, 0xcc, 0xbf, 0xc2,
		0xab, 0x6d, 0x7f, 0xdd, 0x56, 0xf6, 0x93, 0xb3, 0xe9, 0x8b, 0x3a, 0xc9, 0x75, 0xd2, 0xf3, 0x7a, 
		0x14, 0x3f, 0xe1, 0x1c, 0x5c, 0xd9, 0x80, 0x40, 0x3c, 0x8e, 0xf4, 0x46, 0x51, 0x80, 0x52, 0xce, 
		0xc0, 0xd6, 0xe6, 0x1a, 0xba, 0x51, 0x69, 0x6e, 0xf7, 0xf9, 0x05, 0x79, 0xdc, 0x27, 0x4a, 0xa3, 
		0x9c, 0x96, 0x34, 0x9a, 0x3e, 0x56, 0x82, 0xac, 0xdf, 0xc3, 0x26, 0x6a, 0xc1, 0xe8, 0x91, 0x1c,
		0xe3, 0x4d, 0x6b, 0xab, 0x26, 0x06, 0x59, 0x24, 0xbf, 0xcf, 0xbd, 0xcc, 0xbc, 0x42, 0xc8, 0xf7, 
		0x6d, 0x4d, 0x29, 0xc2, 0x3b, 0x9e, 0x72, 0xfc, 0x5e, 0xeb, 0xa0, 0x0f, 0x59, 0x12, 0x04, 0x1f, 
		0xc3, 0xbf, 0xd2, 0xa7, 0x8e, 0x35, 0x94, 0x69, 0x65, 0x71, 0x30, 0x30, 0x4d, 0xb2, 0xfe, 0xa4, 
		0xad, 0x0e, 0xfb, 0x72, 0x29, 0xf7, 0xd0, 0xa6, 0xf4, 0x95, 0xb5, 0x23, 0xd4, 0x3c, 0x54, 0x50, 
		0x2c, 0x1b, 0xc2, 0xf5, 0x72, 0xd8, 0xa9, 0xa5, 0x22, 0x2b, 0xf9, 0x09, 0x03, 0xf1, 0x46, 0x95, 
		0x44, 0x68, 0x8c, 0x2c, 0xd0, 0xbf, 0xa6, 0x6a, 0x71, 0x7a, 0x08, 0x14, 0x2c, 0x38, 0x03, 0x84},  
        /*TST_GeneratorSize;*/
        256*sizeof(DxUint8_t),
		/*TST_Prime - P*/
		{0xB5,0x32,0xB3,0x50,0x76,0xFE,0xDE,0xC9,0x3B,0xF5,0x80,0xA1,0x25,0x92,0xC3,0x96,
		0xC6,0xC9,0x62,0x19,0xE1,0x86,0x07,0xA7,0x38,0xAA,0x78,0x3C,0x32,0xDB,0x0F,0xD7,
		0x56,0x4E,0xEC,0xA9,0x59,0x0E,0xE2,0x4B,0x23,0x0D,0x5D,0xF2,0x3D,0x7E,0xCD,0x31,
		0x53,0x2B,0xD2,0xEE,0x91,0x4E,0xD9,0xEF,0x82,0x0A,0xE3,0x14,0x96,0xB2,0xFA,0xBA,
		0xAF,0x1E,0x9A,0xC1,0x88,0x01,0xFB,0x2D,0xF3,0xAD,0xB9,0xAB,0x4B,0xC0,0x69,0x24,
		0xEC,0x9B,0xAD,0x7E,0xF2,0xCB,0x2D,0x63,0x0E,0x37,0xE9,0x19,0x30,0x7E,0x7D,0xEC,
		0x33,0xC5,0x38,0xF7,0x07,0x6A,0x15,0xFE,0x72,0x6B,0xAC,0x37,0x6B,0x13,0x67,0xFA,
		0x97,0x44,0x2A,0xDD,0x05,0x25,0xB5,0x36,0xA9,0xA2,0x29,0x4A,0x2C,0x8D,0x5A,0x55,
		0x24,0x1F,0xA6,0x20,0x21,0xB5,0xA5,0x98,0xB7,0xE1,0x98,0x72,0x2E,0x6A,0x11,0x93,
		0x0A,0x88,0x47,0x54,0x8D,0xF3,0xB7,0x58,0xA9,0x5E,0x26,0x81,0x3D,0xB5,0x6C,0xC7,
		0x85,0x36,0x19,0xE2,0x51,0xFB,0x68,0x51,0xD8,0xFA,0xD1,0x07,0x33,0x5A,0x17,0x3C,
		0xB0,0x1B,0xEF,0xA2,0x4C,0x06,0xD0,0x68,0x8F,0xD0,0x67,0xFA,0x1D,0x7C,0x10,0xD8,
		0x81,0x1D,0xBB,0x02,0x61,0x4E,0xC7,0x29,0x95,0x4A,0xE4,0x3E,0x0B,0xFE,0xD2,0x03,
		0xD0,0xCC,0x6F,0x1A,0xB4,0xAE,0xB9,0xFB,0x29,0xB5,0xEC,0x1E,0x2F,0x74,0x40,0x80,
		0x87,0xA3,0x79,0xB5,0x20,0x4A,0xBC,0xDB,0x5D,0x28,0x77,0x43,0xEE,0x58,0x4D,0x40,
		0x2C,0xA1,0x87,0xA9,0xE6,0x89,0xC4,0xF8,0xDB,0xD5,0x67,0x82,0x85,0xF3,0xE0,0x9D},
		/*TST_PrimeSize*/
		256*sizeof(DxUint8_t),
		/*TST_Q*/
		{0xF1,0xC1,0xEB,0x18,0xAA,0x94,0xB1,0xA4,0xB8,0xA4,0x97,0x4B,0x26,0xE5,0xC9,0x0D,
		0x03,0x53,0xD5,0xAD},
		/*TST_QSize*/
		20*sizeof(DxUint8_t), 
		/* TST_FactorJ */
		{
		0xBF,0xDF,0x73,0x69,0x00,0x19,0x3C,0x66,0x1A,0xA1,0x2A,0x0B,0xF1,0x55,0xE6,0xAA,
		0xA6,0xA6,0x08,0x16,0xCA,0x2A,0xB5,0x5B,0x69,0x4C,0xB7,0xE4,0x82,0xF3,0x56,0xB6,
		0x57,0x01,0xD8,0xAD,0x8F,0x64,0x63,0x62,0x4E,0xD0,0x8A,0xE4,0x4E,0x2C,0xF6,0x73,
		0xE9,0x53,0xF9,0xD2,0x98,0x63,0x6B,0x53,0xD8,0xEC,0x1B,0xB7,0x8F,0xCC,0xA3,0xBB,
		0x6E,0x88,0xE2,0x32,0x6D,0x2F,0x0C,0xC9,0xA0,0xA0,0xFB,0x30,0x72,0xED,0x5B,0xA1,
		0x8F,0x4E,0xD3,0xC9,0x26,0xB1,0x9A,0x7F,0xB2,0x70,0x65,0x65,0xB7,0xB8,0x32,0xB3,
		0xEE,0x78,0xAF,0xC0,0x21,0x49,0x39,0xA8,0x30,0x7A,0x29,0x72,0x49,0x85,0xEB,0x98,
		0x5F,0x94,0xC6,0x4D,0xFD,0x92,0xF6,0x6A,0x6F,0x10,0xDC,0x6F,0x23,0x14,0xB6,0x17,
		0xA6,0x0C,0x67,0xC7,0x2E,0xF6,0x9D,0x03,0x09,0x29,0xB9,0xB9,0x95,0x2E,0x62,0x2A,
		0xD4,0xFE,0x16,0xBD,0x5C,0x80,0xAE,0xDB,0x59,0xC7,0x4D,0xC0,0x1E,0x28,0xB2,0x74,
		0x9B,0x0D,0x08,0x6D,0x6A,0x76,0x88,0x5B,0xD6,0x72,0xC9,0x37,0xC7,0xE5,0x67,0xFD,
		0xE5,0xDB,0x14,0x1C,0x80,0x71,0xB9,0x44,0x07,0x92,0xDC,0xC3,0x29,0x79,0x09,0x64,
		0xDE,0x60,0xF6,0x0C,0x70,0xBC,0x9A,0xED,0x7F,0x63,0x9D,0x00,0xD7,0xB5,0x73,0xC9,
		0x27,0xD7,0xDF,0xD0,0x53,0x35,0xB5,0xC5,0xBC,0x1C,0x78,0xA0,0x2A,0x34,0xA2,0x07,
		0x52,0x1F,0xE4,0xB6,0x3E,0xD1,0x8C,0xED,0xA7,0xEB,0xDE,0x8C
		},
		/* TST_FactorJSize */
		236 *sizeof(DxUint8_t), 
		/* TST_Seed */
		{
		0xA7,0x40,0x74,0x6C,0xF5,0x40,0x7F,0x94,0xC0,0x00,0xAD,0xF1,0x93,0x9B,0x0A,0x40,
		0xE9,0xBA,0x45,0x91
		},
		/* TST_SeedSize */
		160, /* in bits */
        /*TST_hashFunc*/
        CRYS_DH_HASH_SHA1_mode,
        /*TST_DerFunc_mode*/
        CRYS_DH_ASN1_Der_mode,
        /*TST_KeyLenInBits*/
        256,                  
    }
};




